#include "../slim.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../parse/scene_parser.h"
#include "../common/structs.h"
#include "../common/debug.h"

/**********************************
 * reads a file into memory
 **********************************/
int read_scene(scene_data* main_scene)
{
	/******
	 * this should be malloc instead
	 * *****/
	FILE* scene_file;
	char* p = (char*) &(main_scene->file_content);
	int c = 0;

	/* open the file */
	scene_file = fopen( (char *) main_scene->name, "r");
	if(scene_file == 0)
	{
		printd(5, "Error reading file\n");
		return 0;
	}

	/* copy the file to memory */
	while ( (c = getc(scene_file)) != EOF)
	{
		*p = (char)c;
		p++;
	}
   *p = '\0';

   /* close the file */
   fclose(scene_file);

//   printd(-1, "\n----------------------------------------\n");
//   printd(-1, "file contents:\n%s\n", main_scene->file_content);
//   printd(-1, "\n----------------------------------------\n");

   return 1;
}
